// MSVC ViewerView.h : interface of the CMSVCViewerView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MSVCVIEWERVIEW_H__856F07F5_B6C5_11D2_A474_0040C711066C__INCLUDED_)
#define AFX_MSVCVIEWERVIEW_H__856F07F5_B6C5_11D2_A474_0040C711066C__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
#include "DicomViewer.h"
#include "DicomViewerSink.h"	// Added by ClassView
class CQROptions;

class CMSVCViewerView : public CView
{
protected: // create from serialization only
	CMSVCViewerView();
	DECLARE_DYNCREATE(CMSVCViewerView)

// Attributes
public:
	CMSVCViewerDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMSVCViewerView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	CQROptions* pOptions;
	IDicomImagePtr ActiveImage;
	CDicomViewerSink * pSink;
	virtual ~CMSVCViewerView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	CDicomViewer m_viewer;
	DWORD SinkCookie;

// Generated message map functions
protected:
	//{{AFX_MSG(CMSVCViewerView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnEditCopy();
	afx_msg void OnFliph();
	afx_msg void OnFlipv();
	afx_msg void OnLeveldown();
	afx_msg void OnLevelup();
	afx_msg void OnRotate();
	afx_msg void OnWindowwide();
	afx_msg void OnWindownarrow();
	afx_msg void OnDestroy();
	afx_msg void OnZoomin();
	afx_msg void OnUpdateZoomin(CCmdUI* pCmdUI);
	afx_msg void OnZoomout();
	afx_msg void OnUpdateZoomout(CCmdUI* pCmdUI);
	afx_msg void OnStretchtofit();
	afx_msg void OnUpdateStretchtofit(CCmdUI* pCmdUI);
	afx_msg void OnFileApplypresentationstate();
	afx_msg void OnFileExport();
	afx_msg void OnRemoteSendselected();
	afx_msg void OnCineRuncine();
	afx_msg void OnCineReverse();
	afx_msg void OnCineOscillate();
	afx_msg void OnCineStop();
	afx_msg void OnFilePrintdicom();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in MSVC ViewerView.cpp
inline CMSVCViewerDoc* CMSVCViewerView::GetDocument()
   { return (CMSVCViewerDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MSVCVIEWERVIEW_H__856F07F5_B6C5_11D2_A474_0040C711066C__INCLUDED_)
